$TITLE CGE4
$OFFUPPER

*INTRODUCTION====================================================
$ONTEXT

In this file, the starting point is CGE3b.
New feature: government
The line before any new feature or modification starts with "*++"
Search for " *Complete!! " for some errors and omissions
Move " $ONTEXT " after completing the first " *Complete!! "
and press [SHIFT] [F9] to check the coding up to that point

$OFFTEXT

*SETS============================================================

SETS

 AC global set (SAM accounts and other items)
   /AGR-A   agricultural activity
    NAGR-A  non-agricultural activity
    AGR-C   agricultural commodity
    NAGR-C  non-agricultural commodity
    LAB     labor
    CAP     capital
    U-HHD   urban household
    R-HHD   rural household
*++
    GOV     government
    S-I     savings-investment
*++
    YTAX    income tax
*++
    STAX    sales tax
    TOTAL   total account in SAM   /

 ACNT(AC) all elements in AC except total

 A(AC)  activities
        /AGR-A, NAGR-A/

 C(AC)  commodities
        /AGR-C, NAGR-C/

 F(AC)  factors
        /LAB, CAP/

*++
*Complete!! we introduce a new set for institutions, which will become
*useful at a later stage
 I(AC)  institutions
        /                 /

 H(I)  households
        /U-HHD, R-HHD/
   ;

 ALIAS(AC,ACP); ALIAS(C,CP); ALIAS(F,FP); ALIAS(I,IP);
 ACNT(AC) = YES; ACNT('TOTAL') = NO; ALIAS(ACNT,ACNTP);


*PARAMETERS======================================================

PARAMETERS

 ad(A)       efficiency parameter in the production fn for a ??
 alpha(F,A)  share of value-added to factor f in activity a
 beta(C,H)   share of household consumption spending on commodity c
 cpi         consumer price index
 cwts(C)     weight of commodity c in the CPI
 ica(C,A)    qnty of c as intermediate input per unit of activity a
*++
 qg(C)       government demand for commodity c
 qinvbar(C)  base-year qnty of investment demand for commodity c
 shry(H,F)   share for household h in the income of factor f
 theta(A,C)  yield of output c per unit of activity a
*++
 tq(C)       rate of sales tax for commodity c
*++
 tr(I,IP)    transfer from institution ip to institution i
*++
 ty(H)       rate of income tax for household h
 ;

*VARIABLES=======================================================

VARIABLES
*++
 EG        government expenditures
*++
 GS        government savings

 IADJ      investment adjustment factor
 MPS(H)    marginal (and average) propensity to save for household h
 P(C)      demander price for commodity c
 PA(A)     price of activity a
 PVA(A)    value-added (or net) price for activity a
*++
 PX(C)     producer price for commodity c

 Q(C)      output level for commodity c
 QA(A)     level of activity a
 QF(F,A)   quantity demanded of factor f from activity a
 QFS(F)    supply of factor f
 QH(C,H)   quantity consumed of commodity c by household h
 QINT(C,A) qnty of commodity c as intermediate input to activity a
 QINV(C)   quantity of investment demand for commodity c
 WALRAS    dummy variable (zero at equilibrium)
 WF(F)     average price of factor f
 WFDIST(F,A) wage distortion factor for factor f in activity a

 YF(H,F)   income of household h from factor f
*++
 YG        government revenue
 YH(H)     income of household h

*++
 YTAXADJ   income taxes adjustment factor

 ;

*EQUATIONS=======================================================

EQUATIONS

*PRICE, PRODUCTION AND COMMODITY BLOCK++++++++
 PRODFN(A)      Cobb-Douglas production function for activity a
 FACDEM(F,A)    demand for factor f from activity a
 INTDEM(C,A)    intermediate demand for commodity c from activity a
 OUTPUTFN(C)    output of commodity c
*++
 PDEF(C)        demander price for commodity c
 PADEF(A)       price for activity a
 PVADEF(A)      value-added price for activity a

*INSTITUTION BLOCK+++++++++++++++++++++
 FACTTRNS(H,F)  transfer of income from factor f to h-hold h
 HHDINC(H)      income of household h
 HHDEM(C,H)     consumption demand for household h & commodity c
 INVDEM(C)      investment demand for commodity c
*++
 GOVREV         government revenue
*++
 GOVEXP         government expenditures
*++
 GSAV           government savings

*SYSTEM CONSTRAINT BLOCK+++++++++++++++
 FACTEQ(F)      market equilibrium condition for factor f
 COMEQ(C)       market equilibrium condition for commodity c
 SAVINV         savings-investment balance
 PNORM          price normalization
 ;

*PRICE, PRODUCTION AND COMMODITY BLOCK++++++++

 PRODFN(A)..    QA(A) =E= ad(A)*PROD(F, QF(F,A)**alpha(F,A));

 FACDEM(F,A)..  WF(F)*WFDIST(F,A) =E= alpha(F,A)*PVA(A)*QA(A) / QF(F,A);

 INTDEM(C,A)..  QINT(C,A) =E= ica(C,A)*QA(A);

 OUTPUTFN(C)..  Q(C) =E= SUM(A, theta(A,C)*QA(A));
*++
*Complete!!  We have declared a new price equation for the
*demander price for commodity c, complete it here!!
 PDEF(C)..            =E=
*++
*Complete!! Which is the appropriate price to use here. Goods leave
*the factory gate as they are purchased by the economy-wide Pick&Pay
*is it the producer price, PX(C), or the consumer price, P(C)?
 PADEF(A)..     PA(A) =E= SUM(C, theta(A,C)*     );

 PVADEF(A)..    PVA(A) =E= PA(A) - SUM(C, P(C)*ica(C,A));

*INSTITUTION BLOCK+++++++++++++++++++++

 FACTTRNS(H,F)..  YF(H,F)
                  =E= shry(H,F)*SUM(A, WF(F)*WFDIST(F,A)*QF(F,A));

*++
*Complete!! What needs to be added to household income as defined
*in the previous exercise??
 HHDINC(H)..      YH(H) =E= SUM(F, YF(H,F)) +         ;
*++
*Complete!! Household demand is now a function of after-tax income which
*in turn was already defined net of savings as per exercise CGE3a. Here you
*have to expand the equation to represent the notion of after-tax income.
 HHDEM(C,H)..     QH(C,H) =E=
                  beta(C,H)*(1 - MPS(H))*                 *YH(H)/P(C);

 INVDEM(C)..      QINV(C) =E= qinvbar(C)*IADJ;
*++
*Complete!! Define government revenue consisting of an indirect tax
*component and a direct tax component. Don't forget the adjustment scalar.
 GOVREV..                  =E=
*++
*Complete!! Define government expenditure as the sum commodities purchased
*plus transfers made to households
 GOVEXP..                  =E=
*++
*Complete!! Define government savings as the difference between revenue and
*expenditure
 GSAV..                    =E=

*SYSTEM CONSTRAINT BLOCK+++++++++++++++

 FACTEQ(F)..      SUM(A, QF(F,A)) =E= QFS(F);

*++
*Complete!! Add government expenditure to the commodity  balance condition
 COMEQ(C)..       Q(C) =E= SUM(H, QH(C,H)) + SUM(A, QINT(C,A))
                  + QINV(C) +   ????????       ;
*++
*Complete!! Add government savings to the savings investment balance
 SAVINV..         SUM(C, P(C)*QINV(C)) + WALRAS =E=
                  SUM(H, MPS(H)*(1 - YTAXADJ*ty(H))*YH(H)) + ?????????;

 PNORM..          SUM(C, cwts(C)*P(C)) =E= cpi;

*MODEL===========================================================

MODELS

 CGE4  Model with gov't and flexible factor market treatment
 /ALL/
 ;

*SOCIAL ACCOUNTING MATRIX========================================
*++
*Complete!!
TABLE SAM(AC,ACP)  social accounting matrix

       AGR-A  NAGR-A   AGR-C   NAGR-C  LAB   CAP
 AGR-A                   255
 NAGR-A                           350
 AGR-C    66      44
 NAGR-C   44      66
 LAB      72     105
 CAP      73     135
 U-HHD                                  95   125
 R-HHD                                  82    83
 GOV
 S-I
 YTAX
 STAX


 +       U-HHD   R-HHD   GOV   S-I  YTAX   STAX
 AGR-A
 NAGR-A
 AGR-C      55      77    11    27
 NAGR-C    110      55    47    61
 LAB
 CAP
 U-HHD                    25
 R-HHD                     5
 GOV
 S-I        60      33    -5
 YTAX
 STAX
 ;

PARAMETER
 tdiff(AC) column minus row total for account AC;
          SAM('TOTAL',ACNTP) = SUM(ACNT, SAM(ACNT,ACNTP));
          SAM(ACNT,'TOTAL') = SUM(ACNTP, SAM(ACNT,ACNTP));
          tdiff(ACNT)       = SAM('TOTAL',ACNT) - SAM(ACNT,'TOTAL');

DISPLAY SAM, tdiff;


*ASSIGNMENTS FOR PARAMETERS AND VARIABLES========================

PARAMETERS
*The following parameters are used to define initial values of
*model variables.
*++
 EG0, IADJ0, MPS0(H), P0(C), PA0(A), PVA0(A), PX0(C), Q0(C), QA0(A),
 QF0(F,A), QFS0(F), QH0(C,H), QINT0(C,A), QINV0(C), WF0(F),
 WFDIST0(F,A), YF0(H,F), YG0, YH0(H), GS0, YTAXADJ0, WALRAS0
 ;


*FACTOR EMPLOYMENT AND PRICES++++++++++

PARAMETERS
 labor(A)     quantity of labor employed by activity (no. of workers)
              /AGR-A  100, NAGR-A 50/
 wfa(F,A)     wage for factor f in activity a (only for calibration)
 costgap(F,A) gap calibrated factor cost - SAM value (should be zero)
 ;

*Defining factor employment and supply
 QF0('LAB',A) = labor(A);
 QF0('CAP',A) = SAM('CAP',A);
 QFS0(F)      = SUM(A, QF0(F,A));

*Computing activity-specific wage
 wfa(F,A)     = SAM(F,A)/QF0(F,A);

*Computing average wage
 WF0(F)       = SUM(A, SAM(F,A))/SUM(A, QF0(F,A));

*Computing wage distortion factors
 WFDIST0(F,A) = wfa(F,A) / WF0(F);

*Checking calibration
 costgap(F,A) = WF0(F)*WFDIST0(F,A)*QF0(F,A) - SAM(F,A);

DISPLAY wfa, costgap;


*PRICE, PRODUCTION AND COMMODITY BLOCK++++++++

 PA0(A)     = 1;
*++
 PX0(C)     = 1;
 PVA0(A)    = SUM(F, SAM(F,A)) / (SAM(A,'TOTAL')/PA0(A));

*++
*Complete!!
 tq(C)      = ;
*++
*Complete!!
 P0(C)      = PX0(C)*(1 +   );

 Q0(C)      = SAM('TOTAL',C)/P0(C);
 QA0(A)     = SAM('TOTAL',A)/PA0(A);
 QINT0(C,A) = SAM(C,A)/P0(C);

 alpha(F,A) = SAM(F,A) / SUM(FP, SAM(FP,A));
 ad(A)      = QA0(A) / PROD(F, QF0(F,A)**alpha(F,A));
 ica(C,A)   = (SAM(C,A)/P0(C)) / QA0(A);
*++
*Complete!! Remember that the yield of output c per unit of activity a
*was previously expressed in terms of a price for commodity c which was the
*same before and after sales tax, as we hadn't introduced the latter yet.
*Now, we have to be a bit more careful and express this parameter in terms of
*the appropriate price. Which price would that be, producer price, PX(C),
*or the consumer price, P(C)?
 theta(A,C) = (SAM(A,C)/    ) / QA0(A);

*INSTITUTION BLOCK+++++++++++++++++++++

*++
 EG0         = SAM('TOTAL','GOV') - SAM('S-I','GOV');
 IADJ0       = 1;
*++
*Complete!! Initialise the marginal propensity to save by taking the ratio
*of the relevant SAM entries. Remember that the MPS is taken from "after tax
*income, so don't just take the column total from the SAM!!
 MPS0(H)     = SAM('S-I',H) / (       ?????               );
 QH0(C,H)    = SAM(C,H)/P0(C);
 QINV0(C)    = SAM(C,'S-I')/P0(C);
 YF0(H,F)    = SAM(H,F);
*++
*Complete!! Initialise government revenue, by reading it off the SAM. Is it a
*value or a quantity?
 YG0         =     ;
 YH0(H)      = SAM('TOTAL',H);

 beta(C,H)   = SAM(C,H)/SUM(CP, SAM(CP,H));
*++
*Complete!! Initialise government expenditure here as a parameter, i.e.,
*We will keep it constant during simulations (at least in this version of the
*model)
 qg(C)       = ?????          ;
 qinvbar(C)  = SAM(C,'S-I')/P0(C);
 shry(H,F)   = SAM(H,F)/SAM('TOTAL',F);
*++
*Complete!! initialise government transfers. Is it a value or a quantity?
 tr(H,'GOV') =    ??????  ;
*++
 ty(H)       = SAM('YTAX',H) / SAM('TOTAL',H);

*++
*Complete!! Initialise government savings
 GS0         =
*++
*Complete!!  What is the initial value of the income tax adjustment scalar
*in the base solution?
 YTAXADJ0    =

*SYSTEM CONSTRAINT BLOCK+++++++++++++++

 cwts(C)     = SUM(H, SAM(C,H)) / SUM((CP,H), SAM(CP,H));
 cpi         = SUM(C, cwts(C)*P0(C));

*INITIALISATION OF VARIABLES+++++++++++

 EG.L        = EG0;
 IADJ.L      = IADJ0;
 MPS.L(H)    = MPS0(H);
 P.L(C)      = P0(C);
 PA.L(A)     = PA0(A);
 PVA.L(A)    = PVA0(A);
 PX.L(C)     = PX0(C);
 Q.L(C)      = Q0(C);
 QA.L(A)     = QA0(A);
 QF.L(F,A)   = QF0(F,A);
 QFS.L(F)    = QFS0(F);
 QH.L(C,H)   = QH0(C,H);
 QINT.L(C,A) = QINT0(C,A);
 QINV.L(C)   = QINV0(C);
 WF.L(F)     = WF0(F);
 WFDIST.L(F,A) = WFDIST0(F,A);
 YF.L(H,F)   = YF0(H,F);
 YG.L        = YG0;
 YH.L(H)     = YH0(H);

*++ Note this closure doesn't do much as we're only solving for the base, so
*a closure swap would not have any impact
 GS.FX       = GS0;
 YTAXADJ.L   = YTAXADJ0 ;

*DISPLAY+++++++++++++++++++++++++++++++

DISPLAY
 ad, alpha, beta, cpi, cwts, ica, shry, qg, qinvbar, theta, tr, ty, tq,
*++
 EG.L, GS.L,   IADJ.L, MPS.L, P.L, PA.L, PVA.L, PX.L, Q.L, QA.L, QF.L, QFS.L,
 QH.L, QINT.L, QINV.L, WF.L, WFDIST.L, YF.L, YG.L, YH.L, YTAXADJ.L
 ;

 CGE4.HOLDFIXED = 1;

 SOLVE CGE4 USING MCP;

*$ONTEXT
*SETS AND PARAMETERS FOR SIMULATIONS AND REPORTS++++++++

SETS
 SIM  simulations
     /BASE   base simulation
      CINCIDSFE increase in capital stock with Inv driven savings and FE
      CINCSDIUE increase in capital stock with Sav driven investment and UE
*++
      QGINCGSFX increase in government consumption balanced budget option
      QGINCGSFL increase in government consumption with YTAXADJ fixed
      /
      ;
*SELECTING CLOSURES++++++++++++++++++++

*SAVINGS-INVESTMENT BALANCE

PARAMETER
 SICLOS(SIM)    savings-investment closure
*Select 1 or 2
*if SICLOS = 1, savings is investment-driven
*if SICLOS = 2, investment is savings-driven

 CAPCLOS(SIM)   closure for capital market
*Select 1 or 2
*if CAPCLOS = 1, capital is mobile and fully employed
*if CAPCLOS = 2, capital is activity-specific and fully employed

 LABCLOS(SIM)   closure for labor market
*Select 1 or 2
*if LABCLOS = 1, labor is mobile and fully employed
*if LABCLOS = 2, labor is mobile and unemployed (fixed wages)

*++
 GOVCLOS(SIM)   government closure
*Select 1 or 2
*if GOVCLOS = 1, balance budget with gvt savings fixed and YTAXADJ flexible
*if GOVCLOS = 2, deficit financed with flexiable gvt savings (YTAXADJ fixed)

;
*DEFAULT VALUES FOR CLOSURES
 SICLOS (SIM)  = 1 ;
 CAPCLOS(SIM)  = 1 ;
 LABCLOS(SIM)  = 1 ;
*++
 GOVCLOS(SIM)  = 1;

*OVERWRITE THESE VALUES FOR SPECIFIC SIMULATIONS BELOW
*eg  SICLOS('CAPINCR') = 2
 SICLOS ('CINCIDSFE') = 1;
 SICLOS ('CINCSDIUE') = 2;
 LABCLOS('CINCIDSFE') = 1;
 LABCLOS('CINCSDIUE') = 2;
*++
 GOVCLOS('QGINCGSFX') = 1;
 GOVCLOS('QGINCGSFL') = 2;
 LABCLOS('QGINCGSFX') = 2;
 LABCLOS('QGINCGSFL') = 2;
*++
DISPLAY SICLOS, CAPCLOS, LABCLOS, GOVCLOS ;

PARAMETERS
*++
 QGSIM(C,SIM)     government consumption of c for sim

 QFSCAPSIM(SIM)   supply of capital for simulation sim
*++
 QGREP(C,SIM)     government consumption of c for sim (check)
*++
 GSREP(SIM)       government savings
*++
 EGREP(SIM)       government expenditures
 IADJREP(SIM)     investment adjustment factor
 MPSREP(H,SIM)    marginal (and avg) propensity to save for household h
 PREP(C,SIM)      demander price for commodity c
 PAREP(A,SIM)     price of activity a
 PVAREP(A,SIM)    value-added price for activity a
 PXREP(C,SIM)     producer price (excl. sales tax) for commodity c
 QREP(C,SIM)      output level for commodity c
 QAREP(A,SIM)     level of activity a
 QFREP(F,A,SIM)   demand for factor f from activity a
 QFSREP(F,SIM)    supply of factor f for sim
 QHREP(C,H,SIM)   consumption of commodity c by household h
 QINTREP(C,A,SIM) qnty of commodity c as intermed. input for activity a
 QINVREP(C,SIM)   quantity of investment by commodity of origin c
 WFREP(F,SIM)     average price of factor f
 WFAREP(F,A,SIM)  price of factor f for activity a
 WFDISTREP(F,A,SIM) wage distortion factof for factor f in activity a
 YFREP(H,F,SIM)   income of household h from factor f
 YHREP(H,SIM)     income of household h
 WALRASREP(SIM)   dummy variable (zero at equilibrium)
*++
 YGREP(SIM)       government revenue
*++
 YTAXADJREP(SIM)  income tax adjustment factor

 ;

 QFSCAPSIM(SIM)          =     qfs.L('CAP');
 QFSCAPSIM('CINCIDSFE')  = 1.1*qfs.L('CAP');
 QFSCAPSIM('CINCSDIUE')  = 1.1*qfs.L('CAP');



*++ Here we would like you to introduce a simulation that evaluate a 20%
*increase in government quantity demand for goods.

 QGSIM(C,SIM)         =     qg(C);
 QGSIM(C,'QGINCGSFX') = 1.1*qg(C);
 QGSIM(C,'QGINCGSFL') = 1.1*qg(C);

DISPLAY QFSCAPSIM, QGSIM  ;
*$ONTEXT

LOOP(SIM,

 qfs0('CAP') = QFSCAPSIM(SIM);
*++
 qg(C) = QGSIM(C,SIM);

IF(SICLOS(SIM) EQ 1,
*Investment-driven savings -- MPS('U-HHD') is flexible, permitting
*the savings value to adjust.
 IADJ.FX         = IADJ0;
 MPS.FX('R-HHD') = MPS0('R-HHD');
 MPS.LO('U-HHD') = -INF; MPS.UP('U-HHD') = +INF;
 MPS.L('U-HHD')  = MPS0('U-HHD');
 );

IF(SICLOS(SIM) EQ 2,
*Savings-driven investment -- IADJ is flexible, permitting
*investment quantities and the investment value to adjust.
 MPS.FX(H) = MPS0(H);
 IADJ.LO   = -INF; IADJ.UP = +INF; IADJ.L = IADJ0;
 );

IF(CAPCLOS(SIM) EQ 1,
*Capital is fully employed and mobile. WF('CAP') is the market-clearing
*variable for the unified capital market.

 WFDIST.FX('CAP',A) = WFDIST0('CAP',A);

 WF.LO('CAP')       = -INF; WF.UP('CAP') = +INF;
 WF.L('CAP')        = WF0('CAP');

 QF.LO('CAP',A)     = -INF; QF.UP('CAP',A) = +INF;
 QF.L('CAP',A)      = QF0('CAP',A);

 QFS.FX('CAP')      = QFS0('CAP');
 );

IF(CAPCLOS(SIM) EQ 2,
*Capital is fully employed and activity-specific.
*WFDIST('CAP',A) is the market-clearing variable, one for
*each segment of the capital market.

 WFDIST.LO('CAP',A) = -INF; WFDIST.UP('CAP',A) = +INF;
 WFDIST.L('CAP',A)  = WFDIST0('CAP',A);

 WF.FX('CAP')       = WF0('CAP');

 QF.FX('CAP',A)     = QF0('CAP',A);

 QFS.LO('CAP') = -INF; QFS.UP('CAP') = +INF;
 QFS.L('CAP') = QFS0('CAP');
 );

IF(LABCLOS(SIM) EQ 1,
*Labor is fully employed and mobile. WF('LAB') is the market-clearing
*variable for the unified labour market.

 WFDIST.FX('LAB',A) = WFDIST0('LAB',A);

 WF.LO('LAB') = -INF; WF.UP('LAB') = +INF;
 WF.L('LAB')  = WF0('LAB');

 QF.LO('LAB',A) = -INF; QF.UP('LAB',A) = +INF;
 QF.L('LAB',A) = QF0('LAB',A);

 QFS.FX('LAB')      = QFS0('LAB');
 );

IF(LABCLOS(SIM) EQ 2,
*Labor is unemployed and mobile. For each activity, the wage,
*WFDIST('LAB',A)*WF('LAB'), is fixed. QFS('LAB') is the market-clearing
*variable for the unified labor market.

 WFDIST.FX('LAB',A) = WFDIST0('LAB',A);

 WF.FX('LAB')   = WF0('LAB');

 QF.LO('LAB',A) = -INF; QF.UP('LAB',A) = +INF;
 QF.L('LAB',A)  = QF0('LAB',A);

 QFS.LO('LAB')= -INF; QFS.UP('LAB') = +INF;
 QFS.L('LAB') = QFS0('LAB');

 );

*GOVERNMENT CLOSURE
* 1 if balance budget with government savings fixed and YTAXADJ flexible
* 2 if deficit financed with YTAXADJ fixed
*Complete!!

IF(GOVCLOS(SIM) EQ 1,




 );

*Complete!!
IF(GOVCLOS(SIM) EQ 2,




 );

 CGE4.HOLDFIXED = 1;

 SOLVE CGE4 USING MCP;
*++
 QGREP(C,SIM)     = qg(c);
*++
 GSREP(SIM)      = GS.L;
*++
 EGREP(SIM)       = EG.L;

 IADJREP(SIM)       = IADJ.L;
 MPSREP(H,SIM)      = MPS.L(H);
 PREP(C,SIM)        = P.L(C);
 PAREP(A,SIM)       = PA.L(A);
 PVAREP(A,SIM)      = PVA.L(A);
*++
 PXREP(C,SIM)       = PX.L(C);
 QREP(C,SIM)        = Q.L(C);
 QAREP(A,SIM)       = QA.L(A);
 QFREP(F,A,SIM)     = QF.L(F,A);
 QFSREP(F,SIM)      = QFS.L(F);
 QHREP(C,H,SIM)     = QH.L(C,H);
 QINTREP(C,A,SIM)   = QINT.L(C,A);
 QINVREP(C,SIM)     = QINV.L(C);
 WFREP(F,SIM)       = WF.L(F);
 WFAREP(F,A,SIM)    = WF.L(F)*WFDIST.L(F,A);
 WFDISTREP(F,A,SIM) = WFDIST.L(F,A);
 YFREP(H,F,SIM)     = YF.L(H,F);
*++
 YGREP(SIM)         = YG.L;
 YHREP(H,SIM)       = YH.L(H);
 WALRASREP(SIM)     = WALRAS.L;
*++
 YTAXADJREP(SIM)  = YTAXADJ.L ;

 );

 OPTION QFREP:3:1:1, QHREP:3:1:1, QINTREP:3:1:1, WFAREP:3:1:1,
        WFAREP:3:1:1, WFDISTREP:3:1:1, YFREP:3:1:1
       ;

DISPLAY
 EGREP, IADJREP, MPSREP, PREP, PAREP, PVAREP,  PXREP, QGREP, QREP,
 QAREP, QFREP, QFSREP, QHREP, QINTREP, QINVREP, WFREP, WFAREP,
 WFDISTREP, YFREP, YGREP, YHREP, WALRASREP, GSREP, YTAXADJREP
 ;

*Parameters reporting %-age change from BASE for model variables and
*for selected other data.
PARAMETERS

 GSREPP(SIM)       government savings
 EGREPP(SIM)       government expenditures
 IADJREPP(SIM)     investment adjustment factor
 MPSREPP(H,SIM)    marginal (and avg) propensity to save for household h
 PREPP(C,SIM)      demander price for commodity c
 PAREPP(A,SIM)     price of activity a
 PVAREPP(A,SIM)    value-added price for activity a
 PXREPP(C,SIM)     producer price (excl. sales tax) for commodity c
 QREPP(C,SIM)      output level for commodity c
 QAREPP(A,SIM)     level of activity a
 QFREPP(F,A,SIM)   demand for factor f from activity a
 QGREPP(C,SIM)     government consumption of c for sim (check)
 QFSREPP(F,SIM)    supply of factor f for simulation sim (%ch)
 PREPP(C,SIM)      demander price for commodity c (%ch)
 PAREPP(A,SIM)     price of activity a (%ch)
 QREPP(C,SIM)      output level for commodity c (%ch)
 QAREPP(A,SIM)     level of activity a (%ch)
 QFREPP(F,A,SIM)   demand for factor f from activity a (%ch)
 QHREPP(C,H,SIM)   consumption of commodity c by household h (%ch)
 YFREPP(H,F,SIM)   income of household h from factor f (%ch)
 WFREPP(F,SIM)     price of factor f (%ch)
 YHREPP(H,SIM)     income of household h (%ch)
 ;

 GSREPP(SIM)      = 100*(GSREP(SIM)/GSREP('BASE') - 1);
 QGREPP(C,SIM)    = 100*(QGREP(C,SIM)/QGREP(C,'BASE') - 1);
 EGREPP(SIM)      = 100*(EGREP(SIM)/EGREP('BASE') - 1);
 IADJREPP(SIM)    = 100*(IADJREP(SIM)/IADJREP('BASE') - 1);
 MPSREPP(H,SIM)   = 100*(MPSREP(H,SIM)/MPSREP(H,'BASE') - 1);
 PREPP(C,SIM)     = 100*(PREP(C,SIM)/PREP(C,'BASE') - 1);
 PAREPP(A,SIM)    = 100*(PAREP(A,SIM)/PAREP(A,'BASE') - 1);
 PVAREPP(A,SIM)   = 100*(PVAREP(A,SIM)/PVAREP(A,'BASE') - 1);
 PXREPP(C,SIM)    = 100*(PXREP(C,SIM)/PXREP(C,'BASE') - 1);
 QREPP(C,SIM)     = 100*(QREP(C,SIM)/QREP(C,'BASE') - 1);
 QAREPP(A,SIM)    = 100*(QAREP(A,SIM)/QAREP(A,'BASE') - 1);
 QFREPP(F,A,SIM)  = 100*(QFREP(F,A,SIM)/QFREP(F,A,'BASE') - 1);
 QFSREPP(F,SIM)   = 100*(QFSREP(F,SIM)/QFSREP(F,'BASE') - 1);
 PREPP(C,SIM)     = 100*(PREP(C,SIM)/PREP(C,'BASE') - 1);
 PAREPP(A,SIM)    = 100*(PAREP(A,SIM)/PAREP(A,'BASE') - 1);
 QREPP(C,SIM)     = 100*(QREP(C,SIM)/QREP(C,'BASE') - 1);
 QAREPP(A,SIM)    = 100*(QAREP(A,SIM)/QAREP(A,'BASE') - 1);
 QFREPP(F,A,SIM)  = 100*(QFREP(F,A,SIM)/QFREP(F,A,'BASE') - 1);
 QHREPP(C,H,SIM)  = 100*(QHREP(C,H,SIM)/QHREP(C,H,'BASE') - 1);
 WFREPP(F,SIM)    = 100*(WFREP(F,SIM)/WFREP(F,'BASE') - 1);
 YFREPP(H,F,SIM)  = 100*(YFREP(H,F,SIM)/YFREP(H,F,'BASE') - 1);
 YHREPP(H,SIM)    = 100*(YHREP(H,SIM)/YHREP(H,'BASE') - 1);


OPTION QFREPP:3:1:1, QHREPP:3:1:1, YFREPP:3:1:1;

DISPLAY
*++
 EGREPP, IADJREPP, MPSREPP, PREPP, PAREPP, PVAREPP, PXREPP, GSREPP, QGREPP,
 QREPP,  QAREPP, QFREPP,   QFSREPP,  PREPP, PAREPP, QREPP,   QAREPP,
 QFREPP, QHREPP, WFREPP,   YFREPP,  YHREPP
 ;
$OFFTEXT